<?php
/**
* @package direct-as-a-service
* @subpackage views
 * @filesource
*/ /** */

	$this->load->view('api/header'); 
	$this->load->view('api/nav'); 
?>
				<h1>API Documentation Directory</h1>
				<p>Below is a list of the available web services and links to their documentation.</p>
				<table class="display">
					<tr>
						<th width="25%">Name</th>
						<th width="25%">Endpoint</th>
						<th width="50%" class="displaylast">Description</th>
					</tr>
					<tr>
						<td><a href="/onboarding/disclosure/">Accounting of Disclosure</a></td>
						<td>/disclosure</td>
						<td>The Disclosure web service allows authorized applications to retrieve Accounting of Disclosure information and can be accessed by sending a GET request to /disclosure.</td>
					</tr>
					<tr>
						<td><a href="/onboarding/disclosure_log/">Log Disclosure</a></td>
						<td>/direct/disclosure/log</td>
						<td>The Disclosure Log web service allows authorized applications to send required disclosure information and can be accessed by sending a POST request to /direct/disclosure/log.</td>
					</tr>
					<tr>
						<td><a href="/onboarding/folders/">Retrieve Folders</a></td>
						<td>/direct/folders</td>
						<td>The Folders web service allows authorized applications to return all custom folders using the Direct standards and can be accessed by sending a GET request to /direct/folders. An example of the Headers and Arguments for the Folders GET request can be seen below.</td>
					</tr>
					<tr>
						<td><a href="/onboarding/archive_folder/">Archive Folder</a></td>
						<td>/direct/folders/archive</td>
						<td>The Archive Folder web service allows authorized applications to delete a folder and all messages within it will be moved to the archive folder and can be accessed by sending a POST request to /direct/folders/archive.</td>
					</tr>
					<tr>
						<td><a href="/onboarding/create_folder/">Create Folder</a></td>
						<td>/direct/folders/create</td>
						<td>The Create Folder web service allows authorized applications to create a new folder for a mailbox (user or group) and can be accessed by sending a POST request to /direct/folders/create.</td>
					</tr>
					<tr>
						<td><a href="/onboarding/rename_folder/">Rename Folder</a></td>
						<td>/direct/folders/rename</td>
						<td>The Rename Folder web service allows authorized applications to rename an existing folder and can be accessed by sending a POST request to /direct/folders/rename.</td>
					</tr>
					<tr>
						<td><a href="/onboarding/message/">Retrieve Messages</a></td>
						<td>/direct/messages</td>
						<td>The message web service allows authorized applications to retrieve and search messages and can be accessed by sending a GET request to /direct/messages.</td>
					</tr>
					<tr>
						<td><a href="/onboarding/archive/">Archive Message</a></td>
						<td>/direct/messages/archive</td>
						<td>The Archive Message web service allows authorized applications to archive messages and can be accessed by sending a POST request to /direct/messages/archive.</td>
					</tr>
					<tr>
						<td><a href="/onboarding/count/">Message Count</a></td>
						<td>/direct/messages/count</td>
						<td>The Count web service allows authorized applications to find the counts of messages that would be retrieved if pulling the messages using the same criteria and can be accessed by sending a GET request to /direct/messages/count. This service is useful for determining how many messages a potential retrieve call will return.</td>
					</tr>
					<tr>
						<td><a href="/onboarding/move/">Move Message</a></td>
						<td>/direct/messages/move</td>
						<td>The Move Message web service allows authorized applications to move messages from one folder to another and can be accessed by sending a POST request to /direct/messages/move.</td>
					</tr>
					<tr>
						<td><a href="/onboarding/restore/">Restore Message</a></td>
						<td>/direct/messages/restore</td>
						<td>The Restore Message web service allows authorized applications to restore message to a folder if that folder still exists and can be accessed by sending a POST request to /direct/messages/restore.</td>
					</tr>
					<tr>
						<td><a href="/onboarding/save/">Save Message</a></td>
						<td>/direct/messages/save</td>
						<td>The Save Message web service allows authorized applications to save messages as drafts and can be accessed by sending a POST request to /direct/messages/save.</td>
					</tr>
					<tr>
						<td><a href="/onboarding/send/">Send Message</a></td>
						<td>/direct/send</td>
						<td>The send web service allows authorized applications to send messages using the Direct standards and can be accessed by sending a POST request to /direct/send.</td>
					</tr>
					<tr>
						<td><a href="/onboarding/send_draft/">Send Draft Message</a></td>
						<td>/direct/send/draft</td>
						<td>The Send Draft web service allows authorized applications to send messages using the Direct standards that have been stored as drafts in the past and can be accessed by sending a POST request to /direct/send/draft.</td>
					</tr>
					<tr>
						<td><a href="/onboarding/validate/">Validate Trust</a></td>
						<td>/direct/validate</td>
						<td>The validate web service allows authorized applications to check if a Direct address is a trusted recipient and can be accessed by sending a GET request to /direct/validate.</td>
					</tr>
				</table>
			</div>
			<?PHP $this->load->view('api/footer'); ?>
		</div>
	</body>
</html>